CREATE OR REPLACE FORCE EDITIONABLE VIEW "AB03B"."AB03B10V00INIOBRA" ("ID_ANO_010", "ID_010", "ID_PROV_010", "PROVINCIA_TRABAJO_056", "NUM_REG_010", "ID_EXPEDIENTE", "FEC_REG_010", "TIPO_DOC_044", "NIF_EMPRESA_047", "RAZON_SOCIAL_047", "CALLE_047", "NUM_CALLE_047", "PISO_047", "LETRA_047", "CP_047", "LOCALIDAD_047", "MUNICIPIO_047", "PROVINCIA_047", "REPRESENTANTE_LEGAL_047", "TELF1_047", "TELF2_047", "EMAIL_047", "NUM_RERA_047", "ACTIVO_SN_047", "PROVINCIA_TRABAJO_010", "PROV_DO", "MUNICIP_TRABAJO_010", "MUN_DO", "CALLE_TRABAJO_010", "NUMERO_TRABAJO_010", "PISO_TRABAJO_010", "LETRA_TRABAJO_010", "CPOSTAL_TRABAJO_010", "F_INICIO_TRABAJO_010", "DURACION_DIAS_010", "ID_008_TIPO_PLAN", "PLAN_ES", "PLAN_EU", "DESCPLANR_ES", "DESCPLANR_EU", "EXP_SANC_010", "TECN_ASIGN_010", "EXP_ESPECIF_010", "REQ_LEIDO_010", "NOTIF_LEIDA_010", "EXP_CERRADO_010", "ESTADO_EXP_010", "IDIOMA_COMUNIC_010", "ID_001_FASE", "FASE_ES", "FASE_EU", "ID_002_TRAMITE", "TRAMITE_ES", "TRAMITE_EU", "ID_034_ESTADO",
  "ESTADO_ES", "ESTADO_EU", "OBSERVACIONES_014", "ID_047", "FECHA_VISITA_010", "NIF_TITULAR_010", "NOMBRE_TITULAR_010", "APE1_TITULAR_010", "APE2_TITULAR_010", "OID_DOC_VISITA_010", "OID_DOC_SANCION_010")
AS
  SELECT T10.ID_ANO_010,
    T10.ID_010,
    T10.ID_PROV_010,
    T56.PROVINCIA_TRABAJO_056,
    T10.NUM_REG_010,
    T10.ID_PROV_010
    || '/'
    || T10.ID_ANO_010
    || '/'
    || lpad(T10.ID_010,5,'0'),
    T10.FEC_REG_010,
    T47.TIPO_DOC_044,
    T47.NIF_EMPRESA_047,
    NVL(T47.NOMBRE_EMPRESA_047, T47.RAZON_SOCIAL_047) AS RAZON_SOCIAL_047,
    CASE
      WHEN NORACALLEEMP.DS_O IS NULL
      THEN T47.CALLE_047
      ELSE CONCAT(CONCAT(CONCAT(NORACALLEEMP.DS_O,' ('),NORACALLEEMP.TIPO_VIA),')')
    END AS CALLE_EMPRESA,
    T47.NUM_CALLE_047,
    T47.PISO_047,
    T47.LETRA_047,
    T47.CP_047,
    T47.LOCALIDAD_047,
    T47.MUNICIPIO_047,
    T47.PROVINCIA_047,
    T47.REPRESENTANTE_LEGAL_047,
    T47.TELF1_047,
    T47.TELF2_047,
    T47.EMAIL_047,
    T47.NUM_RERA_047,
    T47.ACTIVO_SN_047,
    T10.PROVINCIA_TRABAJO_010,
    NORAPROV.DS_O PROV_DO,
    T10.MUNICIP_TRABAJO_010,
    NORAMUN.DS_O MUN_DO,
    CASE
      WHEN NORACALLE.DS_O IS NULL
      THEN T10.CALLE_TRABAJO_010
      ELSE CONCAT(CONCAT(CONCAT(NORACALLE.DS_O,' ('),NORACALLE.TIPO_VIA),')')
    END AS CALLE_TRABAJO,
    T10.NUMERO_TRABAJO_010,
    T10.PISO_TRABAJO_010,
    T10.LETRA_TRABAJO_010,
    T10.CPOSTAL_TRABAJO_010,
    T10.F_INICIO_TRABAJO_010,
    T10.DURACION_DIAS_010,
    T10.ID_008_TIPO_PLAN,
    T8.DESC_ES_008,
    T8.DESC_EU_008,
    CASE
      WHEN T10.ID_008_TIPO_PLAN = 1
      THEN SUBSTR(T8.DESC_ES_008,1,1)
        ||
        CASE
          WHEN (T47.PROVINCIA_047 = '01'
          OR T47.PROVINCIA_047    = '20'
          OR T47.PROVINCIA_047    = '48')
          THEN 'T'
          ELSE 'F'
        END
      ELSE SUBSTR(T8.DESC_ES_008,1,1)
    END DESCR_ES_008,
    CASE
      WHEN T10.ID_008_TIPO_PLAN = 1
      THEN SUBSTR(T8.DESC_EU_008,1,1)
        ||
        CASE
          WHEN (T47.PROVINCIA_047 = '01'
          OR T47.PROVINCIA_047    = '20'
          OR T47.PROVINCIA_047    = '48')
          THEN 'T'
          ELSE 'F'
        END
      ELSE SUBSTR(T8.DESC_EU_008,1,1)
    END DESCR_EU_008,
    T10.EXP_SANC_010,
    T10.TECN_ASIGN_010,
    T10.EXP_ESPECIF_010,
    T10.REQ_LEIDO_010,
    T10.NOTIF_LEIDA_010,
    T10.EXP_CERRADO_010,
    T10.ESTADO_EXP_010,
    T10.IDIOMA_COMUNIC_010,
    T14.ID_001_FASE,
    FASES.DESC_ES_001 FASE_DESC,
    FASES.DESC_EU_001 FASE_DESE,
    T14.ID_002_TRAMITE,
    TRAMITES.DESC_ES_002 TRAMITE_DESC,
    TRAMITES.DESC_EU_002 TRAMITE_DESE,
    T14.ID_034_ESTADO,
    ESTADOS.DESC_ES_034,
    ESTADOS.DESC_EU_034,
    t14.OBSERVACIONES_014,
    T47.id_047,
    T10.FECHA_VISITA_010,
    T10.NIF_TITULAR_010,
    T10.NOMBRE_TITULAR_010,
    T10.APE1_TITULAR_010,
    T10.APE2_TITULAR_010,
    T10.OID_DOC_VISITA_010,
    T10.OID_DOC_SANCION_010
  FROM AB03B10T00 T10
  LEFT JOIN AB03B47T00 T47
  ON T47.ID_047 = T10.ID_047_EMPRESA
  INNER JOIN AB03B14T00 T14
  ON T14.ID_010_NUM_EXP = T10.ID_010
  AND T14.ID_ANO_010    = T10.ID_ANO_010
  AND T14.ID_PROV_010   = T10.ID_PROV_010
  AND T14.ID_014       IN
    (SELECT MAX(id_014)
    FROM AB03B14T00
    GROUP BY ID_ANO_010,
      ID_010_NUM_EXP,
      ID_PROV_010
    )
  INNER JOIN AB03B08T00 T8
  ON T8.ID_008 = T10.ID_008_TIPO_PLAN
  INNER JOIN AB03B01T00 FASES
  ON FASES.ID_001 = T14.ID_001_FASE
  INNER JOIN AB03B02T00 TRAMITES
  ON TRAMITES.ID_001_FASE = T14.ID_001_FASE
  AND TRAMITES.ID_002     = T14.ID_002_TRAMITE
  INNER JOIN AB03B34T00 ESTADOS
  ON ESTADOS.ID_034= T14.ID_034_ESTADO
    --AND TRAMITES.ID_001_FASE||TRAMITES.ID_002<>11
  LEFT JOIN T17I.T17_PROVINCIA NORAPROV
  ON NORAPROV.ID = T10.PROVINCIA_TRABAJO_010
  LEFT JOIN T17I.T17_MUNICIPIO NORAMUN
  ON NORAMUN.PROVINCIA_ID = T10.PROVINCIA_TRABAJO_010
  AND NORAMUN.ID          = T10.MUNICIP_TRABAJO_010
  LEFT JOIN T17I.T17_CALLE NORACALLE
  ON NORACALLE.PROVINCIA_ID  = T10.PROVINCIA_TRABAJO_010
  AND NORACALLE.MUNICIPIO_ID = T10.MUNICIP_TRABAJO_010
  AND T10.CALLE_TRABAJO_010 LIKE NORACALLE.ID
  LEFT JOIN T17I.T17_LOCALIDAD NORALOCA
  ON NORALOCA.PROVINCIA_ID  = T47.PROVINCIA_047
  AND NORALOCA.MUNICIPIO_ID = T47.MUNICIPIO_047
  AND NORALOCA.ID           = T47.LOCALIDAD_047
  LEFT JOIN T17I.T17_CALLE NORACALLEEMP
  ON NORACALLEEMP.PROVINCIA_ID  = T47.PROVINCIA_047
  AND NORACALLEEMP.MUNICIPIO_ID = T47.MUNICIPIO_047
  AND T47.CALLE_047 LIKE NORACALLEEMP.ID
  LEFT JOIN AB03B56T00 T56
  ON T56.ID_014                  = T14.ID_014
  AND T56.PROVINCIA_TRABAJO_056 <> T10.ID_PROV_010;